package main

import (
	"fmt"
	"strings"
)

func GetPrometheusTags(tags map[string]string) string {
	if len(tags) < 1 {
		return ""
	}
	pairs := GetRawStringTags(tags)
	out := fmt.Sprintf("{%s}", strings.Join(pairs, ","))
	return out
}

func GetRawStringTags(tags map[string]string) []string {
	pairs := make([]string, 0)
	if len(tags) < 1 {
		return pairs
	}
	for tag, val := range tags {
		s := fmt.Sprintf("%s=\"%s\"", tag, val)
		pairs = append(pairs, s)
	}
	return pairs
}
