package main

import (
	"log"
	"time"
)

var suppress_until time.Time
var lg *log.Logger

func init() {
	suppress_until = time.Now()
	lg = log.Default()
}

func WarnAndSuppress(msg string) {
	now := time.Now()
	if now.Before(suppress_until) {
		return
	}
	lg.Printf("[WARN] Malformed message: %s\n", msg)
	suppress_until = now.Add(time.Second * 30)
}
