Gent - Lightweight monitoring agent
====================================

Gent is a simple application telemetry collector/exporter. It ingests
both regular `StatsD` and its extended variant, `DogStatsD` messages and
generates Prometheus-compatible telemetry. It is designed to be
reasonably small and have no external dependencies.

Gent is intended to be run on the host or inside a container with
direct host networking.

Build instructions
-------------------

```bash
go build
```

That's it. Gent depends only on Go's stdlib.

Using Gent
-----------

Once the agent is running, send `*StatsD` messages to its listening port
(udp/9825). Gent will process the messages and generate an export for
Prometheus-compatible scrapers, listening on port tcp/19013. These
exports are regenerated every 15 seconds.

Example:

```
% curl http://localhost:19013/metrics
####
## INFO counters
# TYPE ctr_X counter
ctr_X{some="info",in="tags",and="other",random="details"} 5896
# TYPE packets_enqueued counter
packets_enqueued{type="internal"} 5896
```

Basic architecture
-------------------

```bash

  | HOST |
+-------------------------------------------------------+
|                                                       |
| +---------------+               +---------------+     |
| |  Service A    |-+           +-|+-------------+|     |
| +---------------+ |           | || Container X ||     |
|                   |[msg]      | |+-------------+|     |
| +---------------+ |[msg]      | +---------------+     |
| |  Service B    |-+      [msg]|                       |
| +---------------+ |           |                       |
|                   |[msg] [msg]|                       |
|                   |      [msg]|                       |
|                   |      [msg]|                       |
|                   |[msg]      |            +------+   |
|                   v           v            | Gent |   |
|                                            |      |   |
+-------------------Y-----------Y------------========---+
               localhost      container-network
```

Performance
------------

Tested on a relatively recent AMD Ryzen 5 @3.3GHz.

With the included `stresser` sources, `gent` can sustain a degenerate
rate of 400k packets per second before dropping messages. Below ~50k
packets per second the CPU utilisation is negligible.

If the ringbuffer size is raised to 2^20, `gent` can keep up with rates
as high as 420k packets per second without stalling.

Miscellania
------------

The name `gent` is a pun, for "a gent".

It is inspired by [bucky3](https://github.com/smarkets/bucky3), a
monitoring agent used internally at Smarkets.

The ringbuffer design is inspired by
[LMAX Disruptor](https://lmax-exchange.github.io/disruptor/disruptor.html) but
takes a few shortcuts to make the implementation easier to reason about.

For practical information on `DogStatsD` message format, see
[this article](https://davidlu1001.github.io/2020/04/22/Send-metric-to-StatsD-Datadog/).
